<?php

/**
 * Competition attachment handler.
 *
 */
class AVForums_Competitions_AttachmentHandler_Competition extends XenForo_AttachmentHandler_Abstract
{
	protected $_competitionModel = null;

	/**
	 * Key of primary content in content data array.
	 *
	 * @var string
	 */
	protected $_contentIdKey = 'competition_id';

	/**
	 * Route to get to AVForums Competitions
	 *
	 * @var string
	 */
	protected $_contentRoute = 'competitions';

	/**
	 * Name of the phrase that describes the conversation_message content type
	 *
	 * @var string
	 */
	protected $_contentTypePhraseKey = 'avforums_competition';

	/**
	 * Determines if attachments and be uploaded and managed in this context.
	 *
	 * @see XenForo_AttachmentHandler_Abstract::_canUploadAndManageAttachments()
	 */
	protected function _canUploadAndManageAttachments(array $contentData, array $viewingUser)
	{
		return true;
	}

	/**
	 * Determines if the specified attachment can be viewed.
	 *
	 * @see XenForo_AttachmentHandler_Abstract::_canViewAttachment()
	 */
	protected function _canViewAttachment(array $attachment, array $viewingUser)
	{
		return true;
	}

	/**
	 * Code to run after deleting an associated attachment.
	 *
	 * @see XenForo_AttachmentHandler_Abstract::attachmentPostDelete()
	 */
	public function attachmentPostDelete(array $attachment, Zend_Db_Adapter_Abstract $db)
	{
		// return false;
	}

	public function getAttachmentConstraints()
	{
		return $this->_getCompetitionModel()->getCompetitionAttachmentConstraints();
	}

	/**
	 * Returns the maximum allowed attachments for this content type.
	 *
	 * @return integer|true If true, there is no limit
	 */
	public function getAttachmentCountLimit()
	{
		return true;
	}

	/**
	 * @return AVForums_Competitions_Model_Competition
	 */
	protected function _getCompetitionModel()
	{
		if (!$this->_competitionModel)
		{
			$this->_competitionModel = XenForo_Model::create('AVForums_Competitions_Model_Competition');
		}

		return $this->_competitionModel;
	}

	/**
	 * @see XenForo_AttachmentHandler_Abstract::_getContentRoute()
	 */
	protected function _getContentRoute()
	{
		return 'competitions';
	}
}